/*
 * Copyright 2009 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.codenarc.rule.basic

import org.codenarc.rule.AbstractAstVisitor
import org.codenarc.rule.AbstractAstVisitorRule
import org.codehaus.groovy.ast.stmt.SwitchStatement

/**
 * Rule that checks for empty switch statements
 *
 * @author Chris Mair
 * @version $Revision: 255 $ - $Date: 2009-12-23 21:46:34 -0500 (Wed, 23 Dec 2009) $
 */
class EmptySwitchStatementRule extends AbstractAstVisitorRule {
    String name = 'EmptySwitchStatement'
    int priority = 2
    Class astVisitorClass = EmptySwitchStatementAstVisitor
}

class EmptySwitchStatementAstVisitor extends AbstractAstVisitor  {
    void visitSwitch(SwitchStatement switchStatement) {
        if (isFirstVisit(switchStatement) && switchStatement.caseStatements.empty) {
            addViolation(switchStatement)
        }
        super.visitSwitch(switchStatement)
    }

}