#   ConVirt   -  Copyright (c) 2009 Convirture Corp.
#   ======
#
# ConVirt is a Virtualization management tool with a graphical user
# interface that allows for performing the standard set of VM operations
# (start, stop, pause, kill, shutdown, reboot, snapshot, etc...). It
# also attempts to simplify various aspects of VM lifecycle management.
#
#
# This software is subject to the GNU General Public License, Version 2 (GPLv2)
# and for details, please consult it at
#
#    http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
#
#
# author : ConVirt Team

# -*- coding: utf-8 -*-

"""Sample model module."""

from sqlalchemy import *
from datetime import datetime
from sqlalchemy import Table, Column
from sqlalchemy.types import Integer, Unicode
from convirt.model import DeclarativeBase, metadata
from convirt.model import DBSession

class Deployment(DeclarativeBase):
    __tablename__ = 'deployment'

    deployment_id = Column(Unicode(50),primary_key=True)
    version = Column(Unicode(50))
    max_sp = Column(Integer,default=0)
    max_server = Column(Integer,default=0)
    max_vm = Column(Integer,default=0)
    max_tg = Column(Integer,default=0)
    max_template = Column(Integer,default=0)
    update_checked_date = Column(DateTime)

    def __repr__(self):
        return '<deployment: id=%s>' % self.deployment_id    
            

