#
# Courier::Filter::Logger::USM class
#
# (C) 2004-2005 Julian Mehnle <julian@mehnle.net>
# $Id: USM.pm,v 1.12 2005/01/17 17:45:02 julian Exp $
#
##############################################################################

package Courier::Filter::Logger::USM;

our $VERSION = '0.16';

use warnings;
use strict;

use base qw(Courier::Filter::Logger);

use Error qw(:try);

use Courier::Error;

use USM::Mail::Address;
use USM::Mail::Message::Rejected;

use constant TRUE   => (0 == 0);
use constant FALSE  => not TRUE;

# Interface:
##############################################################################

sub log_error;
sub log_rejected_message;

# Implementation:
##############################################################################

sub log_error {
    my ($logger, $text) = @_;
    chomp($text);
    STDERR->print($text, "\n");
    return;
}

sub log_rejected_message {
    my ($logger, $message, $reason) = @_;
    
    # Log rejection for every recipient:
    foreach my $recipient ($message->recipients) {
        my $address = USM::Mail::Address->get_by_literal($recipient);
        next if not $address;
            # Unknown (probably foreign) recipient address, don't log rejection.

        my $user = $address->user;
        next if not $user;
            # Unknown USM user, don't log rejection. This should not happen!
        
        try {
            my $rejection = USM::Mail::Message::Rejected->new();
            $rejection->user($user);
            $rejection->delivering_host($message->remote_host);
            $rejection->from_address($message->sender);
            $rejection->to_address($recipient);
            $rejection->subject($message->subject);
            $rejection->reason($reason);
            $rejection->commit();
        }
        otherwise {
            my ($error) = @_;
            $logger->log_error("An error occurred while logging rejected message: $error");
        };
    }

    return;
}

TRUE;
