# theme/classical.rb, copyright (c) 2007 by Vincent Fourmond: 
# The "classical" theme
  
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
  
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details (in the COPYING file).


require 'Tioga/tioga'
require 'CTioga/themes'
require 'CTioga/movingarrays'

module CTioga

  module Themes

    class ClassicalTheme < BaseTheme

      include Tioga::FigureConstants

      # Mainly for listing purposes:
      attr_reader :sets

      def initialize(color_set = 'standard',
                     marker_set = 'standard',
                     # By default, the marker color will match
                     # the line color, even if the latter is set
                     # manually.
                     marker_color_set = :"=>color",
                     linestyle_set = Line_Type_Solid)
        @sets = {
          :colors => MovingArray.new(Data::COLORS, color_set),
          :markers => MovingArray.new(Data::MARKERS, marker_set),
          :markers_colors => MovingArray.new(Data::COLORS, 
                                          marker_color_set),
          :linestyle => MovingArray.new(Data::LINES, linestyle_set)
        }
     end


      def next_curve_style(name)
        style = CurveStyle.new(@sets[:colors].value, 
                               @sets[:markers].value,
                               @sets[:markers_colors].value,
                               @sets[:linestyle].value,
                               name,
                               1.0,
                               false,  # Does not interpolate by default
                               0.5)
        return style
      end

      def choose_set(type, set)
        @sets[type].choose_current_set(set)
      end

    end

    # Some pastel colors... Just a demonstration of what you can
    # actually do.
    class PastelTheme < ClassicalTheme

      def initialize
        super('pastel1')
      end

      def cmdline_extra_args
        return ["--background", "FloralWhite"]
      end

    end

  end

end
