/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#include <kpopupmenu.h>
#include <klocale.h>
#include <ktextbrowser.h>
#include <qpushbutton.h>
#include <qwidgetstack.h>
#include <qtextedit.h>
#include <qurl.h>
#include "favouritemaster.h"
#include "mainwidget.h"
#include "program.h"
#include "blistmaster.h"
#include "forumview.h"
//-----------------------------------------------------------------------------------------------------------------------
ForumView::ForumView(MainWidget *parent, ProgramMaster *programMaster, KListView *lv, QPtrList<Program> *programs, QWidget *frame)
	: BaseView(parent, programMaster, lv, programs, frame)
{
	m_limiter = -1;
	m_req = RT_NONE;
	
	connect(&m_http, SIGNAL(done(bool)), this, SLOT(done(bool)));
	connect(m_parent->pb_leave, SIGNAL(clicked()), this, SLOT(leaveClicked()));
	connect(m_parent->pb_reload, SIGNAL(clicked()), this, SLOT(reload()));
	connect(m_parent->pb_submit, SIGNAL(clicked()), this, SLOT(submit()));
	connect(m_parent->te_text, SIGNAL(textChanged()), this, SLOT(textChanged()));
	connect(&m_timer, SIGNAL(timeout()), this, SLOT(timerDone()));
	connect(m_parent->ktb_forum, SIGNAL(doubleClicked(int,int)), m_parent, SLOT(toggleDetails()));
}
//-----------------------------------------------------------------------------------------------------------------------
ForumView::~ForumView()
{
	m_http.closeConnection();
}
//-----------------------------------------------------------------------------------------------------------------------
void ForumView::aboutToShow()
{
	m_fromView = m_parent->ws_main->visibleWidget();
	Program *program = ((ProgramItem*)m_parent->activeView()->listView()->selectedItem())->program();
	if(program) {
		m_channelId = program->channelId();
		QUrl::encode(m_channelId);
		m_startTime = program->startDT().toString("yyyyMMddhhmm00");
		QUrl::encode(m_startTime);
		m_parent->tl_forum->setText("\"" + program->title() + "\", " + program->channel()->customName() + " @ "
			+ program->startDT().toString("hh:mm (yyyy-MM-dd)"));
	} else
		leaveClicked();
	m_parent->ktb_forum->clear();
	reload();
	m_parent->te_text->setFocus();
}
//-----------------------------------------------------------------------------------------------------------------------
void ForumView::leaveClicked()
{
//	m_http.closeConnection();
	m_parent->ws_main->raiseWidget(m_fromView);
}
//---------------------------------------------------------------------------------------------------------------------------------
void ForumView::reload()
{
	timerDone();
	m_parent->tl_status->setText(i18n("Requesting forum data..."));
	m_req = RT_RELOAD;

	QString query = "chanid=" + m_channelId + "&pstart=" + m_startTime;

	QHttpRequestHeader header("POST", "/forumget.php");
	header.setValue("Host", "mtvg.sourceforge.net");
	header.setContentType("application/x-www-form-urlencoded");
	m_http.setHost("mtvg.sourceforge.net");
	m_http.request(header, query.utf8());
}
//---------------------------------------------------------------------------------------------------------------------------------
void ForumView::submit()
{
	if(m_parent->prefs()->le_name->text().stripWhiteSpace().length() < 1 || m_parent->prefs()->le_location->text().stripWhiteSpace().length() < 1) {
		m_parent->tl_status->setText(i18n("Please enter your Name and Locaton in the Preferences."));
		return;
	}

	int length = m_parent->te_text->text().stripWhiteSpace().length();
	QDateTime now(QDateTime::currentDateTime());

	if(length == 0) {
		m_parent->tl_status->setText(i18n("No text to submit."));
		return;
	} else if(length > 400) {
		m_parent->tl_status->setText(i18n("Current length of text is not allowed."));
		return;
	} else if(m_parent->te_text->text().contains("\n") > 10) {
		m_parent->tl_status->setText(i18n("Please don't use more than 10 returns in a message."));
		return;
	}
	timerDone();
	m_parent->tl_status->setText(i18n("Submitting and refreshing forum data..."));
	m_req = RT_SUBMIT;

	QString posted = now.toString("yyyyMMddhhmmss");
	QUrl::encode(posted);
	QString name = m_parent->prefs()->le_name->text().stripWhiteSpace();
	QUrl::encode(name);
	QString location = m_parent->prefs()->le_location->text().stripWhiteSpace();
	QUrl::encode(location);
	QString text = m_parent->te_text->text().stripWhiteSpace().replace("\n", "<br>");
	QUrl::encode(text);

	QString query = "posted=" + posted + "&name=" + name + "&location=" + location + "&chanid=" + m_channelId + "&pstart="
		+ m_startTime + "&text=" + text;

	QHttpRequestHeader header("POST", "/forumpost.php");
	header.setValue("Host", "mtvg.sourceforge.net");
	header.setContentType("application/x-www-form-urlencoded");
	m_http.setHost("mtvg.sourceforge.net");
	m_http.request(header, query.utf8());
}
//---------------------------------------------------------------------------------------------------------------------------------
void ForumView::timerDone()
{
	QString reload = i18n("&Reload"), subrel = i18n("&Submit && Reload");
	if(m_limiter == -1)
		m_limiter = 10;		// 10 is reasonable, we don't want to overload the server

	if(m_limiter > 0) {
		m_parent->pb_reload->setEnabled(false);
		m_parent->pb_submit->setEnabled(false);
		m_parent->pb_reload->setText(reload + " (" + QString::number(m_limiter) + ")");
		m_parent->pb_submit->setText(subrel + " (" + QString::number(m_limiter) + ")");
		m_timer.changeInterval(1000);
	} else {
		m_parent->pb_reload->setEnabled(true);
		m_parent->pb_submit->setEnabled(true);
		m_parent->pb_reload->setText(reload);
		m_parent->pb_submit->setText(subrel);
		m_timer.stop();
	}
	m_limiter--;
}
//---------------------------------------------------------------------------------------------------------------------------------
void ForumView::textChanged()
{
	QString chrleft = i18n("Characters left");
	int length = m_parent->te_text->text().length();

	if(length > 400)
		m_parent->tl_chars->setText("<font color=\"red\">" + chrleft + ": " + QString::number(400-length) + "</font>");
	else
		m_parent->tl_chars->setText(chrleft + ": " + QString::number(400-length));
}
//---------------------------------------------------------------------------------------------------------------------------------
void ForumView::done(bool error)
{
	if(error) {
		m_parent->tl_status->setText(i18n("Error fetching data from forum, please try again soon."));
		return;
	}
	QString response(m_http.readAll());
	m_data = QString::fromUtf8(response);

	m_parent->ktb_forum->setText(m_data);
	m_parent->ktb_forum->scrollToBottom();
	
	if(m_req == RT_RELOAD)
		m_parent->tl_status->setText(i18n("Forum updated successfully."));
	if(m_req == RT_SUBMIT) {
		m_parent->te_text->clear();
		m_parent->tl_status->setText(i18n("Message submitted and forum updated successfully."));
	}
	m_req = RT_NONE;
}
//---------------------------------------------------------------------------------------------------------------------------------
