/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#ifndef __PROGRAM_H__
#define __PROGRAM_H__
//-----------------------------------------------------------------------------------------------------------------------
#include <qstring.h>
#include <qdatetime.h>
//-----------------------------------------------------------------------------------------------------------------------
class Channel;
//-----------------------------------------------------------------------------------------------------------------------
class Program
{
public:
	Program();

	void setTitle(QString title) { m_title = title; }
	void setSubtitle(QString subtitle) { m_subtitle = subtitle; }
	void setStart(QString start) { m_start = start; setStartDT(); }
	void setStop(QString stop) { m_stop = stop; setStopDT(); calculateDuration(); }
	void setStartDT();
	void setStartDT(QDateTime startDT) { m_startDT = startDT; }
	void setStopDT();
	void setStopDT(QDateTime stopDT) { m_stopDT = stopDT; };
	void setChannelId(QString channelId) { m_channelId = channelId; }
	void setDesc(QString desc) { m_desc = desc; }
	void setCategory(QString category) { if(m_category.isEmpty()) m_category = category; else m_category += (", " + category); }
	void setDirector(QString director) { m_director = director; }
	void setActors(QString actor) { if(m_actors.isEmpty()) m_actors = actor; else m_actors += (", " + actor); }
	void setDate(QString date) { m_date = date; }
	void setAspect(QString aspect) { m_aspect = aspect; }
	void setEpisode(QString episode) { m_episode = episode; }
	void setShowView(QString showView) { m_showView = showView; }
	void calculateDuration();
	void setChannel(Channel *channel) { m_channel = channel; }

	QString title() { return(m_title); }
	QString subtitle() { return(m_subtitle); }
	QString start() { return(m_start); }
	QString stop() { return(m_stop); }
	QDateTime startDT() { return(m_startDT); }
	QDateTime stopDT() { return(m_stopDT); }
	QString channelId() { return(m_channelId); }
	QString desc() { return(m_desc); }
	QString category() { return(m_category); }
	QString director() { return(m_director); }
	QString actors() { return(m_actors); }
	QString date() { return(m_date); }
	QString aspect() { return(m_aspect); }
	QString episode() { return(m_episode); }
	QTime duration() { return(m_duration); }
	Channel* channel() { return(m_channel); }

private:
	QString m_title;
	QString m_subtitle;
	QString m_start;
	QDateTime m_startDT;
	QString m_stop;
	QDateTime m_stopDT;
	QString m_channelId;
	QString m_desc;
	QString m_category;
	QString m_director;
	QString m_actors;
	QString m_date;
	QString m_aspect;
	QString m_episode;
	QString m_showView;
	QTime m_duration;
	Channel *m_channel;

};
//-----------------------------------------------------------------------------------------------------------------------
#endif
//-----------------------------------------------------------------------------------------------------------------------
