#!/bin/bash
#
#   Copyright
#
#       Copyright (C) 2009-2010 Jari Aalto <jari.aalto@cante.net>
#
#   License
#
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program. If not, see <http://www.gnu.org/licenses/>.

Main ()
{
    echo "# Examine miwm project *.cc *h file for Copyright and license"
    echo "# Examine files not written by the primary author"

    for file in $(LC_ALL=C ls *.cc *.h |
	          grep -vFf <(grep -i wise --files-with-matches *.cc *h) )
    do
	if ! grep --with-filename -Ei 'copyright|@|license|author' $file
	then
	    echo "$file: #NO INFORMATION (check manually)"
	fi
    done
}

Main "$@"

# End of file
