/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.ByteArrayList;
import com.carrotsearch.hppc.ByteContainer;
import com.carrotsearch.hppc.hash.ByteHashFunction;

public class ByteStack
extends ByteArrayList {
    public ByteStack() {
    }

    public ByteStack(int initialCapacity) {
        super(initialCapacity);
    }

    public ByteStack(int initialCapacity, ArraySizingStrategy resizer) {
        super(initialCapacity, resizer);
    }

    public ByteStack(int initialCapacity, ArraySizingStrategy resizer, ByteHashFunction hashFunction) {
        super(initialCapacity, resizer, hashFunction);
    }

    public ByteStack(ByteContainer container) {
        super(container);
    }

    public final void push(byte e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public final void push(byte e1, byte e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public final void push(byte e1, byte e2, byte e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public final void push(byte e1, byte e2, byte e3, byte e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public final void push(byte[] elements, int start, int len) {
        assert (start >= 0 && len >= 0);
        this.ensureBufferSpace(len);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, len);
        this.elementsCount += len;
    }

    public final void push(byte ... elements) {
        this.push(elements, 0, elements.length);
    }

    public final int pushAll(ByteContainer container) {
        return this.addAll(container);
    }

    public final void discard(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
    }

    public final void discard() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
    }

    public final byte pop() {
        assert (this.elementsCount > 0);
        byte v = this.buffer[--this.elementsCount];
        return v;
    }

    public final byte peek() {
        assert (this.elementsCount > 0);
        return this.buffer[this.elementsCount - 1];
    }

    public static ByteStack from(byte ... elements) {
        ByteStack stack = new ByteStack(elements.length);
        stack.push(elements);
        return stack;
    }

    public static ByteStack from(ByteContainer container) {
        return new ByteStack(container);
    }
}

