//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Plugin "Fstab preview"
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QtGui/QDockWidget>
#include <QtGui/QTextBrowser>
#include <QtGui/QHBoxLayout>
#include <QtGui/QVBoxLayout>
#include <QtGui/QComboBox>
#include <QtGui/QAction>
#include <QtGui/QLabel>
#include <QtPlugin>
#include "fstabpreview.h"

FstabPreview::FstabPreview(QWidget *parent) {
	mainWidget = new QDockWidget(parent);
	mainWidget->setObjectName("FstabPreview");
	mainWidget->setWindowTitle(tr("Configuration file preview"));
	mainWidget->setAllowedAreas(Qt::RightDockWidgetArea);
	textBrowser = new QTextBrowser;

	comboBox = new QComboBox;
	comboBox->addItem(tr("List"),"list");
	comboBox->addItem(tr("Native"),"native");
	connect(comboBox,SIGNAL(currentIndexChanged(int)),this,SLOT(updateTextBrowser()));

	QWidget *widget = new QWidget;
	QHBoxLayout *topLayout = new QHBoxLayout;
	topLayout->addWidget(new QLabel(tr("View") + ":"));
	topLayout->addWidget(comboBox);
	topLayout->addStretch();

	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addLayout(topLayout);
	mainLayout->addWidget(textBrowser);
	widget->setLayout(mainLayout);

	mainWidget->setWidget(widget);

	QAction *action = mainWidget->toggleViewAction();
	action->setText(tr("Config preview panel"));
	actions.append(action);
}

FstabPreview::~FstabPreview() {
	foreach (QAction *action,actions)
		delete action;
	delete textBrowser;
	delete comboBox;
	delete mainWidget;
}

void FstabPreview::setParent(QObject *parent) {
	connect(parent,SIGNAL(currentFstabContentChanged(const QString &)),this,SLOT(setFstabContent(const QString&)));
}

const QString FstabPreview::pluginName() const {
	return tr("Configuration file preview");
}

const QString FstabPreview::pluginDescription() const {
	return tr("With help of this plugin you can see configuration file which will be used by Linux after apply.");
}

QDialog* FstabPreview::dialog() const {
	return 0;
}

QDockWidget* FstabPreview::dockWidget() const {
	return mainWidget;
}

QMenu* FstabPreview::menu() const {
	return 0;
}

QToolBar* FstabPreview::toolBar() const {
	return 0;
}

Actions FstabPreview::menuActions() const {
	return actions;
}

void FstabPreview::updateTextBrowser() {
	if (comboBox->itemData(comboBox->currentIndex()).toString() == "native") {
		textBrowser->setText(currentText);
		return;
	}
	QString listText;
	foreach (QString line, currentText.split("\n")) {
		if (line.isEmpty())
			continue;
		if (line.contains("#"))
			continue;
		line.replace("\t"," ");
		QStringList list = line.split(" ");
		list.removeAll(" ");
		if (list.count() != 6)
			continue;
		if (list[1].isEmpty())
			list[1] = "<font color='red'>Unknown</font>";
		listText += tr("Device") + ": <b>" + list[0] +"</b><br>"
					+ tr("Mount point") + ": <b>" + list[1] + "</b><br>"
					+ tr("File system") + ": <b>" + list[2] + "</b><br>"
					+ tr("Options") + ": <b>" + list[3] + "</b><br>"
					+ tr("Dump flag") + ": <b>" + list[4] + "</b><br>"
					+ tr("Fsck value") + ": <b>" + list[5] + "</b><hr>";
	}
	textBrowser->setHtml(listText);
}

void FstabPreview::setFstabContent(const QString& content) {
	currentText = content;
	updateTextBrowser();
}

Q_EXPORT_PLUGIN2(fstabpreviewplugin,FstabPreview)
