#ifndef SHARESWIZARD_H
#define SHARESWIZARD_H

#include <QtGui/QWizard>

class QLineEdit;
class QVBoxLayout;
class QGridLayout;
class ChooseMountPointWidget;
class QRadioButton;
class QTextBrowser;
class QPushButton;

class SharesWizard : public QWizard
{
	Q_OBJECT
	signals:
		void finished();
		void canceled();
	public:
		SharesWizard(QWidget *parent = 0);
		~SharesWizard();
	
		QString getType();
		QString getServer();
		QString getServerPath();
		QString getOptions();
		QString getMountPoint();
		QString getName();
		QString getPassword();
	private slots:
		void currentPageChanged(int id);
	private:
		enum Pages { TypePage = 0, ServerPage, MountPointPage, OptionsPage, UserSettingsPage, ResultPage };
	
		QPushButton *finishButton;
		QPushButton *cancelButton;
		
		QWizardPage *typePage;
		QVBoxLayout *typeLayout;
		QRadioButton *nfsTypeButton;
		QRadioButton *sambaTypeButton;
	
		QWizardPage *serverPage;
		QGridLayout *serverLayout;
		QLineEdit *serverLineEdit;
		QLineEdit *remoteDirLineEdit;
	
		QWizardPage *mountPointPage;
		QVBoxLayout *mountPointLayout;
		ChooseMountPointWidget *mountPoint;
	
		QWizardPage *optionsPage;
		QVBoxLayout *optionsLayout;
		QLineEdit *optionsLineEdit;
	
		QWizardPage *userSettingsPage;
		QGridLayout *userSettingsLayout;
		QLineEdit *nameLineEdit;
		QLineEdit *passwordLineEdit;
		
		QWizardPage *resultPage;
		QVBoxLayout *resultLayout;
		QTextBrowser *result;
		
		int nextId() const;
};

#endif
