//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Core
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef DISKDEVICE_H
#define DISKDEVICE_H

#include <QObject>
#include <QString>
#include <QList>

class QDBusInterface;
class DiskFstabItem;

struct ChangeStruct
{
	QString propertyName;
	bool added;
	bool removed;
};

class DiskDevice : public QObject
{
	Q_OBJECT
	signals:
		void currentMountPointChanged(const QString&);
		void mountedStatusChanged(bool);
	private slots:
		void propertyModified(int numChanges,const QList<ChangeStruct> &changes);
	private:
		QDBusInterface *informationCenter;
		QString deviceUdi;
		QString deviceParentUdi;
		QString deviceBlockName;
		QString deviceUuid;
		QString deviceLabel;
		QString deviceFileSystem;
		QString deviceFstabMountPoint;
		QString deviceCurrentMountPoint;
		QString deviceFstabOptions;
		QString deviceType;
		QString deviceCategory;
		QString deviceProduct;
		QString deviceVendor;
		QString deviceFstabFileSystem;
		QString deviceModel;
		QString deviceBus;
		bool removable;
		bool disk;
		bool usb;
		bool cdOrFloppy;
		bool supportDvd;
		qulonglong deviceSize;
		int deviceBlocks;
		int minor;
		int major;

		DiskDevice *parentDevice;
		DiskDevice *cdOrFloppyChildDevice;
		
		DiskFstabItem *fstabItem;
	public:
		DiskDevice(QDBusInterface *interface,const QString &deviceUdi);
		~DiskDevice();

		// Variants of size
		enum Formats { Bytes = 0, KiloBytes, MegaBytes, GigaBytes, Truncation };

		const QString& blockName() const;

		const QString& udi() const;

		const QString& parentUdi() const;
		
		const QString& uuid() const;

		const QString& label() const;

		const QString& fileSystem() const;

		const QString fstabFileSystem() const;
		
		const QString& fstabOptions() const;

		const QString& currentMountPoint();

		const QString& fstabMountPoint() const;

		const QString& type() const;
		
		const QString& category() const;

		const QString& product() const;

		const QString& vendor() const;
		
		const QString& model() const;

		const QString& bus() const;
		
		int blocks() const;
		int majorNumber() const;
		int minorNumber() const;
		int fsck() const;
		
		bool isRemovable() const;
		bool isMounted() const;
		bool isDisk() const;
		bool isUsb() const;
		bool isCdOrFloppy() const;
		bool isSupportDvd() const;
		bool isCdOrFloppyInserted() const;
		bool dump() const;

		qulonglong size() const;
		QString size(int format);
		
		DiskDevice *parent();

		void setFstabItem(DiskFstabItem *item);
		void setParent(DiskDevice *parent);
		void setCdOrFloppyChild(DiskDevice *child);
		void removeCdOrFloppyChild();
};

#endif
