//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Core
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef DISKFSTAB_H
#define DISKFSTAB_H

#include <QList>

class DiskDevice;

struct DiskFstabItem
{
	QString itemName;
	QString itemMountPoint;
	QString itemFileSystem;
	QString itemOptions;
	QString itemLink;
	bool itemDump;
	int itemFsck;
};

class DiskFstab
{
	private:
		QString currentFstabText;
		QString unknownFstabText;
	
		QList<DiskFstabItem *> diskFstabItems;
	public:
		DiskFstab();
		~DiskFstab();

		QString fstabContent();
		const QString& fstabContent() const;

		DiskFstabItem *fstabItem(DiskDevice *device);
		DiskFstabItem *fstabItem(const QString& blockName);

		QList<DiskFstabItem *>& fstabItems();
		const QList<DiskFstabItem *>& fstabItems() const;
		
		// Return QFile::FileError
		int setFstabContent(const QString &newFstabContent);
};

#endif
