//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Core
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef DISKMOUNTOPTIOcNS_H
#define DISKMOUNTOPTIONS_H

#include <QXmlDefaultHandler>
#include <QXmlParseException>
#include <QStringList>

struct Value {
	QString text;
	bool isDefault;
	// If option is check box
	bool isChecked;
};

struct Option {
	QString optionTitle;
	QString optionType;
	QList<Value *> optionValues;
	QStringList optionComboBoxItems;
	QString optionDocMark;
	QString optionDefaultValue;
	QString maximumValue;
	bool isExpertOption;
};

class DiskOptionsParser : public QXmlDefaultHandler
{
	private:
		QList<Option *> optionsList;

		Option *currentOption;
		bool expertNow;
		QString tempText;
		bool isValuesNow;
		bool valid;
		bool isComboBoxItemsNow;
		bool areThereComboBoxItems;
		bool isAcceptComboBoxItems;
		QString comboBoxItemsLocale;
		QString optionTitleLocale;
		QString variantStatus;
		
		QString lang;

		void init();

		bool startElement(const QString&, const QString&, const QString&, const QXmlAttributes&);
		bool characters(const QString& str);
		bool endElement(const QString&, const QString&, const QString&);
		bool fatalError(const QXmlParseException&);
	public:
		DiskOptionsParser(QString lang = QString());
		~DiskOptionsParser();

		bool isValid();
		QList<Option *> options();

		void setLanguage(const QString& lang);

		QString& language();
		const QString& language() const;
};

#endif
