//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>

class QMenu;
class QAction;
class QStatusBar;
class DiskCore;
class DiskDevice;
class CentralWidget;
class QCloseEvent;
class Manual;
class AboutProgramDialog;
class UsbManager;
class PopupWindow;
class QCheckBox;
class RestorationSystem;
class Menu;
class TrayIcon;
class PluginsManager;

class MainWindow : public QMainWindow
{
	Q_OBJECT
	private slots:
		void quit();
		void saveConfig();
		void apply();
		void hideOrShow();
		void showTrayMessage(const QString& title,const QString& message);
		void enablePlugin(int pluginIndex);
		void disablePlugin(int pluginIndex);
	
		void deviceAdded(DiskDevice *addedDevice);
		void deviceRemoved(DiskDevice *removedDevice);

		void reportBug();
		void sendLetterToDeveloper();
		void goToHomepage();
		void goToSupportPage();
	
		void updateWizard();
		void setUsbDeviceAutomount(DiskDevice *device);
	signals:
		void started();
	private:
		DiskCore *core;
		CentralWidget *centralWidget;
		Manual *manual;
		AboutProgramDialog *aboutProgramDialog;
		UsbManager *usbManager;
		RestorationSystem *restorationSystem;
		PluginsManager *pluginsManager;

		TrayIcon *trayIcon;
		Menu *trayMenu;
		
		QDialog *applyDialog;
		QCheckBox *dontShowApplyDialog;

		PopupWindow *popupWindow;
		
		QMenu *partitionMenu;
		QAction *quitAction;
		QAction *saveConfigFileAction;
		QAction *applyAction;
		
		QMenu *toolsMenu;
		QAction *pluginsManagerAction;
		QAction *usbManagerAction;
		QAction *restorationSystemAction;
 		QAction *usbWizardAction;

		QMenu *helpMenu;
		QAction *documentationAction;
		QAction *aboutProgramAction;
		QMenu *linksMenu;
		QAction *reportBugAction;
		QAction *developerAction;
		QAction *homePageAction;
		QAction *supportPageAction;

		QMenu *pluginsMenu;

		QAction *mountAllAction;
		QAction *unmountAllAction;

		bool isFirstStart;

		QStatusBar *statBar;
		
		void saveSettings();
		void loadSettings();
		void loadPlugins();
	public:
		MainWindow();
		~MainWindow();
	protected:
		void closeEvent(QCloseEvent *);
};

#endif
