//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef PLUGINSMANAGER_H
#define PLUGINSMANAGER_H

#include <QDialog>
#include <QList>

class QPluginLoader;
class QSplitter;
class QListWidget;
class QLabel;
class QPushButton;
class MountManagerPlugin;
class QListWidgetItem;

class PluginsManager : public QDialog
{
	Q_OBJECT
	private slots:
		void currentItemChangedSlot(QListWidgetItem *currentItem,QListWidgetItem* previousItem);
		void enablePlugin(QListWidgetItem *item = 0);
		void disablePlugin();
		void showPlugin();
	signals:
		void pluginEnabled(int id);
		void pluginDisabled(int id);
	private:
		enum ItemData { PluginType = 3, PluginDescription, PluginEnabled, PluginFileName };
		
		QPluginLoader *pluginLoader;
		QSplitter *splitter;
		QListWidget *listWidget;
		QWidget *rightWidget;
		QLabel *headerLabel;
		QLabel *descriptionLabel;

		QPushButton *enableButton;
		QPushButton *disableButton;
		QPushButton *showButton;
		
		QList<MountManagerPlugin *> pluginsList;
	public:
		PluginsManager(QWidget *parent = 0);
		~PluginsManager();

		// Scan special directory and load plugins
		void update();

		void saveSettings();

		QList<MountManagerPlugin *>& plugins();

		bool isPluginEnabled(MountManagerPlugin *plugin);
};

#endif
