#include "wb_config.h"
#include "find_panel.h"
#include "workbench/wb_find_dialog.h"
#include "workbench/wb_context_ui.h"
#include <gtkmm/table.h>
#include <gtkmm/button.h>
#include <gtkmm/entry.h>
#include <gtkmm/scrolledwindow.h>
#include "listmodel_wrapper.h"
#include "auto_completable.h"
#include "base/string_utilities.h"

//------------------------------------------------------------------------------
FindPanel::FindPanel(GtkVBox *obj, const Glib::RefPtr<Gtk::Builder> &b)
  : Gtk::VBox(obj)
{
  reference();
  unparent();
}

//------------------------------------------------------------------------------
void FindPanel::init(wb::WBContextUI *wbui, Glib::RefPtr<Gtk::Builder> ui)
{
  _wbui= wbui;
  _ui= ui;
  _be= wbui->get_find_dialog();

  _be->set_search_diagram_only(true);

  Gtk::Button *btn;
  _ui->get_widget("close_button", btn);
  btn->signal_clicked().connect(sigc::mem_fun(this, &FindPanel::handle_close));

  Gtk::Entry *entry;
  _ui->get_widget("find_entry", entry);
  entry->signal_key_press_event().
    connect_notify(sigc::bind(sigc::mem_fun(this, &FindPanel::key_press), entry));

  _ui->get_widget("next_button", btn);
  btn->signal_clicked().connect(sigc::mem_fun(this, &FindPanel::find_next));

  _ui->get_widget("previous_button", btn);
  btn->signal_clicked().connect(sigc::mem_fun(this, &FindPanel::find_previous));

}

//------------------------------------------------------------------------------
FindPanel::~FindPanel()
{
}

//------------------------------------------------------------------------------
void FindPanel::handle_close()
{
  hide();
}

//------------------------------------------------------------------------------
FindPanel *FindPanel::create(wb::WBContextUI *wbui)
{
  Glib::RefPtr<Gtk::Builder> ui= Gtk::Builder::create_from_file(wbui->get_wb()->get_grt_manager()->get_data_file_path("find.glade"));
  FindPanel *panel= 0;

  ui->get_widget_derived<FindPanel>("find_parts_box", panel);

  if (panel)
    panel->init(wbui, ui);

  return panel;
}

//------------------------------------------------------------------------------
void FindPanel::key_press(GdkEventKey *ev, Gtk::Entry *entry)
{
  if (ev->keyval == GDK_Return || ev->keyval == GDK_Linefeed)
  {
    Gtk::Button *btn;
    _ui->get_widget("next_button", btn);
    btn->clicked();
  }
  else if (ev->keyval == GDK_Escape)
    handle_close();
  else
    entry->modify_base(Gtk::STATE_NORMAL, Gdk::Color("#ffffff"));
}


//------------------------------------------------------------------------------
void FindPanel::setup_arguments()
{
  Gtk::Entry *entry;
  Gtk::ToggleButton *check;

  _ui->get_widget("find_entry", entry);
  _be->set_text(entry->get_text().c_str());

  _ui->get_widget("case_check", check);
  _be->set_match_case(check->get_active());

  _ui->get_widget("comment_check", check);
  _be->set_search_in_comments(check->get_active());
}

//------------------------------------------------------------------------------
void FindPanel::find_next()
{
  Gtk::Entry *entry = 0;
  _ui->get_widget("find_entry", entry);

  setup_arguments();

  switch (_be->find_next())
  {
  case wb::NotFound:
    entry->modify_base(Gtk::STATE_NORMAL, Gdk::Color("#ffaaaa"));
    break;
  case wb::FoundMatch:
    entry->modify_base(Gtk::STATE_NORMAL, Gdk::Color("#aaffaa"));
    break;
  case wb::NoMoreMatches:
    entry->modify_base(Gtk::STATE_NORMAL, Gdk::Color("#ffffff"));
    break;
  }
}

//------------------------------------------------------------------------------
void FindPanel::find_previous()
{
  setup_arguments();
  
  Gtk::Entry *entry;
  _ui->get_widget("find_entry", entry);

  setup_arguments();

  switch (_be->find_previous())
  {
  case wb::NotFound:
    entry->modify_base(Gtk::STATE_NORMAL, Gdk::Color("#ffaaaa"));
    break;
  case wb::FoundMatch:
    entry->modify_base(Gtk::STATE_NORMAL, Gdk::Color("#aaffaa"));
    break;
  case wb::NoMoreMatches:
    entry->modify_base(Gtk::STATE_NORMAL, Gdk::Color("#ffffff"));
    break;
  }
}

//------------------------------------------------------------------------------
void FindPanel::show()
{
  Gtk::VBox::show();
  
  Gtk::Entry *entry;
  _ui->get_widget("find_entry", entry);

  entry->modify_base(Gtk::STATE_NORMAL, Gdk::Color("#ffffff"));
  entry->grab_focus();
  entry->select_region(0, entry->get_text().length());
}

