
// tcalc.cpp
// Copyright (c) 1998-2010 by The VoxBo Development Team

// This file is part of VoxBo
// 
// VoxBo is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// VoxBo is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with VoxBo.  If not, see <http://www.gnu.org/licenses/>.
// 
// For general information on VoxBo, including the latest complete
// source code and binary distributions, manual, and associated files,
// see the VoxBo home page at: http://www.voxbo.org/
// 
// original version written by Tom King

#include "tcalc.h"

#include <qvariant.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <q3textedit.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <q3whatsthis.h>
#include <qlineedit.h>
//Added by qt3to4:
#include <QCloseEvent>

/* 
 *  Constructs a thresholdCalculator as a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */

threshold v;
int flag;

thresholdCalculator::thresholdCalculator( QWidget* parent, const char* name, bool modal, Qt::WFlags fl )
    : QDialog( parent, name, modal, fl )

{
    if ( !name )
	setName( "thresholdCalculator" );
    flag = 0;
    lbldenomdf = new QLabel( this, "lbldenomdf" );
    lbldenomdf->setGeometry( QRect( 60, 160, 62, 20 ) );
                                                                                                                 
    lblFWHM = new QLabel( this, "lblFWHM" );
    lblFWHM->setGeometry( QRect( 40, 90, 90, 33 ) );
                                                                                                                 
    lblY = new QLabel( this, "lblY" );
    lblY->setGeometry( QRect( 180, 40, 16, 16 ) );
                                                                                                                       
    lblZ = new QLabel( this, "lblZ" );
    lblZ->setGeometry( QRect( 220, 40, 16, 16 ) );
                                                                                                                 
    lblEffDf = new QLabel( this, "txtEffDf" );
    lblEffDf->setGeometry( QRect( 80, 130, 38, 20 ) );
                                                                                                               
    lblX = new QLabel( this, "lblX" );
    lblX->setGeometry( QRect( 140, 40, 20, 16 ) );
                                                                                                                   
    lblalpha = new QLabel( this, "lblalpha" );
    lblalpha->setGeometry( QRect( 80, 190, 39, 20 ) );
                                                                                                                      
    lblVoxelSizes = new QLabel( this, "lblVoxelSizes" );
    lblVoxelSizes->setGeometry( QRect( 10, 60, 116, 20 ) );
                                                                                                                    
    lblVoxelNumber = new QLabel( this, "lblVoxelNumber" );
    lblVoxelNumber->setGeometry( QRect( 60, 10, 57, 20 ) );
                                                                                                                    
    txtVoxelNumber = new QLineEdit( this, "txtVoxelNumber" );
    txtVoxelNumber->setGeometry( QRect( 130, 10, 130, 23 ) );
    connect(txtVoxelNumber, SIGNAL(textChanged(const QString &)), this, SLOT(pressed()));            
  
    txtX = new QLineEdit( this, "txtX" );
    txtX->setGeometry( QRect( 130, 60, 31, 23 ) );
    connect(txtX, SIGNAL(textChanged(const QString &)), this, SLOT(pressed()));            
                     
    txtY = new QLineEdit( this, "txtY" );
    txtY->setGeometry( QRect( 170, 60, 31, 23 ) );
    connect(txtY, SIGNAL(textChanged(const QString &)), this, SLOT(pressed()));       
                        
    txtZ = new QLineEdit( this, "txtZ" );
    txtZ->setGeometry( QRect( 210, 60, 31, 23 ) );
    connect(txtZ, SIGNAL(textChanged(const QString &)), this, SLOT(pressed()));     
                          
    txtFWHM = new QLineEdit( this, "txtFWHM" );
    txtFWHM->setGeometry( QRect( 130, 90, 130, 23 ) );
    connect(txtFWHM, SIGNAL(textChanged(const QString &)), this, SLOT(pressed()));

    txtAlpha = new QLineEdit( this, "txtAlpha" );
    txtAlpha->setGeometry( QRect( 130, 190, 130, 23 ) );
    connect(txtAlpha, SIGNAL(textChanged(const QString &)), this, SLOT(pressed()));
                                                                                                              
    txtDenomDf = new QLineEdit( this, "txtDenomDf" );
    txtDenomDf->setGeometry( QRect( 130, 160, 131, 23 ) );
    connect(txtDenomDf, SIGNAL(textChanged(const QString &)), this, SLOT(pressed()));
                                                                                                               
    txtEffdf = new QLineEdit( this, "txtEffdf" );
    txtEffdf->setGeometry( QRect( 130, 130, 131, 23 ) );
    connect(txtEffdf, SIGNAL(textChanged(const QString &)), this, SLOT(pressed()));         
                   
    //pbUpdate = new QPushButton( this, "pbUpdate" );
    //pbUpdate->setGeometry( QRect( 20, 220, 100, 30 ) );
    //connect(pbUpdate, SIGNAL(clicked()), this, SLOT(pressed()));    
                                                                                                                
    lblCriticalT = new QLabel( this, "lblCriticalT" );
    lblCriticalT->setGeometry( QRect( 37, 230, 60, 20 ) );
                                                                                                               
    lblCriticalT_2 = new QLabel( this, "lblCriticalT_2" );
    lblCriticalT_2->setGeometry( QRect( 77, 250, 91, 20 ) );
                                                                                                                
    lblCriticalT_3 = new QLabel( this, "lblCriticalT_3" );
    lblCriticalT_3->setGeometry( QRect( 30, 270, 150, 20 ) );

    lblCriticalTValue = new QLabel( this, "lblCriticalTValue" );
    lblCriticalTValue->setGeometry( QRect( 170, 250, 100, 20 ) );
                                                                                                                
    lblCriticalT_4 = new QLabel( this, "lblCriticalT_4" );
    lblCriticalT_4->setGeometry( QRect( 170, 270, 100, 20 ) );             
                                    
    languageChange();
    resize( QSize(281, 302).expandedTo(minimumSizeHint()) );
}

/*
 *  Destroys the object and frees any allocated resources
 */
thresholdCalculator::~thresholdCalculator() {
    if (v.pValPeak) gsl_vector_free(v.pValPeak);
    if (v.pValExtent) gsl_vector_free(v.pValExtent);
    if (v.peakthreshold) gsl_vector_free(v.peakthreshold);
    if (v.pvalpeak) gsl_vector_free(v.pvalpeak);
    if (v.bonpeakthreshold) gsl_vector_free(v.bonpeakthreshold);
    if (v.bonpvalpeak) gsl_vector_free(v.bonpvalpeak);
    if (v.clusterthreshold) gsl_vector_free(v.clusterthreshold);
    if (v.peakthreshold1) gsl_vector_free(v.peakthreshold1);
    if (v.pvalpeak1) gsl_vector_free(v.pvalpeak1);
    if (v.extentthreshold) gsl_vector_free(v.extentthreshold);
    if (v.extentthreshold1) gsl_vector_free(v.extentthreshold1);
    if (v.pvalextent) gsl_vector_free(v.pvalextent);
    if (v.pvalextent1) gsl_vector_free(v.pvalextent1);
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void thresholdCalculator::languageChange()
{
    setCaption( tr( "Threshold calculator" ) );
    lbldenomdf->setText( tr( "denom df:" ) );
    lblFWHM->setText( tr( "Smoothness \n"
"(fwhm in mm):" ) );
    lblY->setText( tr( "y" ) );
    lblZ->setText( tr( "z" ) );
    lblEffDf->setText( tr( "eff df:" ) );
    lblX->setText( tr( "x" ) );
    lblalpha->setText( tr( "alpha:" ) );
    lblVoxelSizes->setText( tr( "Voxel  Sizes (mm):" ) );
    lblVoxelNumber->setText( tr( "# voxels:" ) );
    lblCriticalT->setText( tr( "Critical t:" ) );
    lblCriticalT_2->setText( tr( "      Bonferroni:" ) );
    lblCriticalTValue->setText( tr( "--------------" ) );
    lblCriticalT_4->setText( tr( "--------------" ) );
    lblCriticalT_3->setText( tr( "  Random Field Theory:" ) );
    //pbUpdate->setText( tr( "Update" ) );
    txtVoxelNumber->insert("50000");
    txtX->insert("3.0");
    txtY->insert("3.0");
    txtZ->insert("3.0");
    txtFWHM->insert("2.0");
    txtEffdf->insert("15");
    txtDenomDf->insert("0");
    txtAlpha->insert("0.05");
    v.pValPeak = gsl_vector_calloc(1);
    v.pValExtent = gsl_vector_calloc(1);
    v.peakthreshold = gsl_vector_calloc((int)v.pValPeak->size);
    v.pvalpeak = gsl_vector_calloc((int)v.pValPeak->size);
    v.bonpeakthreshold = gsl_vector_calloc((int)v.pValPeak->size);
    v.bonpvalpeak = gsl_vector_calloc((int)v.pValPeak->size);
    v.clusterthreshold = gsl_vector_calloc(1);
    v.peakthreshold1 = gsl_vector_calloc((int)v.pValPeak->size);
    v.pvalpeak1 = gsl_vector_calloc((int)v.pValPeak->size);
    v.extentthreshold = gsl_vector_calloc((int)v.pValPeak->size);
    v.extentthreshold1 = gsl_vector_calloc((int)v.pValPeak->size);
    v.pvalextent = gsl_vector_calloc((int)v.pValPeak->size);
    v.pvalextent1 = gsl_vector_calloc((int)v.pValPeak->size);
    gnvar = 0;
    gnconj = 0;
    gPValExtent = 0;
    gClusterThreshold = 0;
    gdfw1 = 0;
    gdfw2 = 0;
    flag = 1;
    pressed();
}

void thresholdCalculator::pressed() {
    if (flag == 0) return;
    v.fwhm = atol(txtFWHM->text());
    v.numVoxels = atol(txtVoxelNumber->text());
    gsl_vector_set(v.pValPeak, 0, atof(txtAlpha->text()));
    if (atof(txtDenomDf->text())) {
       v.df[0] = atof(txtEffdf->text());
       v.df[1] = atof(txtDenomDf->text());
       if (v.df[1]==0) v.df[1]=FLT_MAX;
    }
    else {
       v.df[1] = atof(txtEffdf->text());
       v.df[0] = atof(txtDenomDf->text());
    } 
    v.df[2] = FLT_MAX;
    v.df[3] = FLT_MAX;
    v.searchVolume=atol(txtX->text())*atol(txtY->text())*atol(txtZ->text())*v.numVoxels;
    if (gnvar)
       v.nvar = gnvar;
    else
       v.nvar = 1;
    if (gnconj)
       v.nconj = gnconj;
    else
       v.nconj = 1;
    if (gPValExtent)
       gsl_vector_set(v.pValExtent, 0, gPValExtent);
    else
       gsl_vector_set(v.pValExtent, 0, .05);
    if (gClusterThreshold)
       v.clusterThreshold = gClusterThreshold; 
    else
       v.clusterThreshold = .001;
    if (gdfw1)
       v.df[2] = gdfw1;
    else
      v.df[2] = FLT_MAX;
    if (gdfw2)
       v.df[3] = gdfw2;
    else
      v.df[3] = FLT_MAX;

    char x[STRINGLEN];
    char y[STRINGLEN];
    if ((v.df[0]>2 && v.df[1]==FLT_MAX) || v.df[1]>2) {
      stat_threshold(v);
      if (atol(txtDenomDf->text()))
	lblCriticalT->setText( tr( "Critical F:" ) );
      else
	lblCriticalT->setText( tr( "Critical t:" ) );
      sprintf(y,"%f", gsl_vector_get(v.peakthreshold, 0));
      sprintf(x,"%f", gsl_vector_get(v.bonpeakthreshold, 0));
      if (gsl_vector_get(v.bonpeakthreshold, 0) > 1e99) strcpy (x, "Not Available");
      if (gsl_vector_get(v.peakthreshold, 0) > 1e99) strcpy (y, "Not Available");
    }
    else {
      strcpy(x,"Not Available");
      strcpy(y,"Not Available");
    }
    lblCriticalTValue->setText(x);
    lblCriticalT_4->setText(y);
    if (v.peakthreshold) gsl_vector_set_zero(v.peakthreshold);
    if (v.pvalpeak) gsl_vector_set_zero(v.pvalpeak);
    if (v.bonpeakthreshold) gsl_vector_set_zero(v.bonpeakthreshold);
    if (v.bonpeakthreshold) gsl_vector_set_zero(v.bonpeakthreshold);
    if (v.clusterthreshold) gsl_vector_set_zero(v.clusterthreshold);
    if (v.peakthreshold1) gsl_vector_set_zero(v.peakthreshold1);
    if (v.pvalpeak1) gsl_vector_set_zero(v.pvalpeak1);
    if (v.extentthreshold) gsl_vector_set_zero(v.extentthreshold);
    if (v.extentthreshold1) gsl_vector_set_zero(v.extentthreshold1);
    if (v.pvalextent) gsl_vector_set_zero(v.pvalextent);
    return;
}
                                                                                                             
void thresholdCalculator::closeEvent( QCloseEvent *ce ){
    ce->accept();
    return;
}

